/** @file   barrellcontroller.h
 * @brief   Declaration of BarrellController - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_BARRELLCONTROLLER_H
#define H_WWW_BARRELLCONTROLLER_H

#include "basecontroller.h"


namespace WeWantWar {

/** @class  BarrellController
 * @brief   Controls the BarrellObject.
 * @author  Tomi Lamminsaari
 *
 */
class BarrellController : public BaseController
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  
  
  /** Waiting state id. Barrel does nothing but exists. */
  static const int KWaiting = 0;
  /** Waiting for explosion state id. Barrel stays still until the
   * primary target is close enough. Then it explodes.
   */
  static const int KProwl = 1;
  /** Rolling state id. Barrel starts rollings. */
  static const int KRolling = 2;
  
  

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	BarrellController( GameObject* aOwner );


	/** Destructor
   */
	virtual ~BarrellController();

private:

	/** Copy constructor.
   * @param     rO                Reference to another BarrellController
   */
  BarrellController( const BarrellController& rO );

	/** Assignment operator
   * @param     rO                Reference to another BarrellController
   * @return    Reference to us.
   */
  BarrellController& operator = ( const BarrellController& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates this controller.
   */
  virtual void update();
  
  /** Sets the state.
   * @param     aState            New state
   */
  void setState( int aState );
  

  ///
  /// Getter methods
  /// ==============

  /** Returns the state this barrel is in.
   * @return    Current state
   */
  int state() const;

protected:

  ///
  /// Members
  /// =======

  int iState;
  


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: barrellcontroller.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:48+02  lamminsa
 * Initial revision
 *
 */
 
